--
-- PostgreSQL database dump
--

-- Dumped from database version 14.13 (Debian 14.13-1.pgdg120+1)
-- Dumped by pg_dump version 14.13 (Debian 14.13-1.pgdg120+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: ray; Type: SCHEMA; Schema: -; Owner: gw-user
--

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: connection; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.connection (
    connection_id uuid DEFAULT gen_random_uuid() NOT NULL,
    connection_type character varying(255) NOT NULL,
    label character varying(255) NOT NULL,
    description text NOT NULL,
    params jsonb NOT NULL,
    update_metadata_schedule text,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: connection_domain; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.connection_domain (
    connection_id uuid NOT NULL,
    domain_id uuid NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: connection_permission; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.connection_permission (
    connection_id uuid NOT NULL,
    permission_id uuid NOT NULL,
    user_id uuid,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: domain; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.domain (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name character varying(255) NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: migratehistory; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.migratehistory (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    migrated_at timestamp without time zone NOT NULL
);



--
-- Name: migratehistory_id_seq; Type: SEQUENCE; Schema: ray; Owner: gw-user
--

CREATE SEQUENCE ray.migratehistory_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;



--
-- Name: migratehistory_id_seq; Type: SEQUENCE OWNED BY; Schema: ray; Owner: gw-user
--

ALTER SEQUENCE ray.migratehistory_id_seq OWNED BY ray.migratehistory.id;


--
-- Name: permission; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.permission (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name character varying(255) NOT NULL,
    user_id uuid,
    domain_id uuid,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT permission_name_check CHECK ((TRIM(BOTH FROM name) <> ''::text))
);



--
-- Name: query; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.query (
    query_id uuid DEFAULT gen_random_uuid() NOT NULL,
    query text NOT NULL,
    query_template_code character varying(255) NOT NULL,
    schedule character varying(255),
    name character varying(255) NOT NULL,
    parameters jsonb DEFAULT '{"sources": [], "parameters": []}'::jsonb NOT NULL,
    expected_result jsonb DEFAULT '{"type": "boolean", "value": true}'::jsonb NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: query_domain; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.query_domain (
    query_id uuid NOT NULL,
    domain_id uuid NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: query_permission; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.query_permission (
    query_id uuid NOT NULL,
    permission_id uuid NOT NULL,
    user_id uuid,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);


--
-- Name: query_run; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.query_run (
    query_run_id uuid DEFAULT gen_random_uuid() NOT NULL,
    query_id uuid NOT NULL,
    query_run_status character varying(255) NOT NULL,
    result_status character varying(255),
    result boolean NOT NULL,
    error_msg text,
    return_value jsonb DEFAULT '{"value": null}'::jsonb NOT NULL,
    executed_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT query_run_query_run_status_check CHECK (((query_run_status)::text = ANY ((ARRAY['queued'::character varying, 'running'::character varying, 'success'::character varying, 'failed'::character varying])::text[])))
);



--
-- Name: source_metadata; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.source_metadata (
    connection_id uuid NOT NULL,
    source_table_name character varying(255) NOT NULL,
    columns jsonb,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: user; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray."user" (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    username character varying(255) NOT NULL,
    password bytea NOT NULL,
    full_name character varying(255) NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    is_superuser boolean DEFAULT false NOT NULL
);



--
-- Name: user_domain; Type: TABLE; Schema: ray; Owner: gw-user
--

CREATE TABLE ray.user_domain (
    user_id uuid NOT NULL,
    domain_id uuid NOT NULL,
    created_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);



--
-- Name: migratehistory id; Type: DEFAULT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.migratehistory ALTER COLUMN id SET DEFAULT nextval('ray.migratehistory_id_seq'::regclass);


--
-- Name: connection_domain connection_domain_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_domain
    ADD CONSTRAINT connection_domain_pkey PRIMARY KEY (connection_id, domain_id);


--
-- Name: connection connection_label_key; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection
    ADD CONSTRAINT connection_label_key UNIQUE (label);


--
-- Name: connection_permission connection_permission_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_permission
    ADD CONSTRAINT connection_permission_pkey PRIMARY KEY (connection_id, permission_id);


--
-- Name: connection connection_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection
    ADD CONSTRAINT connection_pkey PRIMARY KEY (connection_id);


--
-- Name: domain domain_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.domain
    ADD CONSTRAINT domain_pkey PRIMARY KEY (id);


--
-- Name: migratehistory migratehistory_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.migratehistory
    ADD CONSTRAINT migratehistory_pkey PRIMARY KEY (id);


--
-- Name: permission permission_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.permission
    ADD CONSTRAINT permission_pkey PRIMARY KEY (id);


--
-- Name: query_domain query_domain_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_domain
    ADD CONSTRAINT query_domain_pkey PRIMARY KEY (query_id, domain_id);


--
-- Name: query_permission query_permission_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_permission
    ADD CONSTRAINT query_permission_pkey PRIMARY KEY (query_id, permission_id);


--
-- Name: query query_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query
    ADD CONSTRAINT query_pkey PRIMARY KEY (query_id);


--
-- Name: query_run query_run_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_run
    ADD CONSTRAINT query_run_pkey PRIMARY KEY (query_run_id);


--
-- Name: source_metadata source_metadata_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.source_metadata
    ADD CONSTRAINT source_metadata_pkey PRIMARY KEY (connection_id, source_table_name);


--
-- Name: user_domain user_domain_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.user_domain
    ADD CONSTRAINT user_domain_pkey PRIMARY KEY (user_id, domain_id);


--
-- Name: user user_pkey; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray."user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (id);


--
-- Name: user user_username_key; Type: CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray."user"
    ADD CONSTRAINT user_username_key UNIQUE (username);


--
-- Name: connection_params; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connection_params ON ray.connection USING gin (params);


--
-- Name: connectiondomain_connection_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connectiondomain_connection_id ON ray.connection_domain USING btree (connection_id);


--
-- Name: connectiondomain_domain_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connectiondomain_domain_id ON ray.connection_domain USING btree (domain_id);


--
-- Name: connectionpermission_connection_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connectionpermission_connection_id ON ray.connection_permission USING btree (connection_id);


--
-- Name: connectionpermission_permission_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connectionpermission_permission_id ON ray.connection_permission USING btree (permission_id);


--
-- Name: connectionpermission_user_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX connectionpermission_user_id ON ray.connection_permission USING btree (user_id);


--
-- Name: permission_domain_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX permission_domain_id ON ray.permission USING btree (domain_id);


--
-- Name: permission_user_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX permission_user_id ON ray.permission USING btree (user_id);


--
-- Name: query_expected_result; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX query_expected_result ON ray.query USING gin (expected_result);


--
-- Name: query_parameters; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX query_parameters ON ray.query USING gin (parameters);


--
-- Name: querydomain_domain_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX querydomain_domain_id ON ray.query_domain USING btree (domain_id);


--
-- Name: querydomain_query_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX querydomain_query_id ON ray.query_domain USING btree (query_id);


--
-- Name: querypermission_permission_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX querypermission_permission_id ON ray.query_permission USING btree (permission_id);


--
-- Name: querypermission_query_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX querypermission_query_id ON ray.query_permission USING btree (query_id);


--
-- Name: querypermission_user_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX querypermission_user_id ON ray.query_permission USING btree (user_id);


--
-- Name: queryrun_query_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX queryrun_query_id ON ray.query_run USING btree (query_id);


--
-- Name: queryrun_return_value; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX queryrun_return_value ON ray.query_run USING gin (return_value);


--
-- Name: sourcemetadata_columns; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX sourcemetadata_columns ON ray.source_metadata USING gin (columns);


--
-- Name: sourcemetadata_connection_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX sourcemetadata_connection_id ON ray.source_metadata USING btree (connection_id);


--
-- Name: userdomain_domain_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX userdomain_domain_id ON ray.user_domain USING btree (domain_id);


--
-- Name: userdomain_user_id; Type: INDEX; Schema: ray; Owner: gw-user
--

CREATE INDEX userdomain_user_id ON ray.user_domain USING btree (user_id);


--
-- Name: connection_domain connection_domain_connection_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_domain
    ADD CONSTRAINT connection_domain_connection_id_fkey FOREIGN KEY (connection_id) REFERENCES ray.connection(connection_id) ON DELETE CASCADE;


--
-- Name: connection_domain connection_domain_domain_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_domain
    ADD CONSTRAINT connection_domain_domain_id_fkey FOREIGN KEY (domain_id) REFERENCES ray.domain(id) ON DELETE CASCADE;


--
-- Name: connection_permission connection_permission_connection_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_permission
    ADD CONSTRAINT connection_permission_connection_id_fkey FOREIGN KEY (connection_id) REFERENCES ray.connection(connection_id) ON DELETE CASCADE;


--
-- Name: connection_permission connection_permission_permission_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_permission
    ADD CONSTRAINT connection_permission_permission_id_fkey FOREIGN KEY (permission_id) REFERENCES ray.connection(connection_id) ON DELETE CASCADE;


--
-- Name: connection_permission connection_permission_user_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.connection_permission
    ADD CONSTRAINT connection_permission_user_id_fkey FOREIGN KEY (user_id) REFERENCES ray."user"(id) ON DELETE CASCADE;


--
-- Name: permission permission_domain_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.permission
    ADD CONSTRAINT permission_domain_id_fkey FOREIGN KEY (domain_id) REFERENCES ray.domain(id) ON DELETE CASCADE;


--
-- Name: permission permission_user_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.permission
    ADD CONSTRAINT permission_user_id_fkey FOREIGN KEY (user_id) REFERENCES ray."user"(id) ON DELETE CASCADE;


--
-- Name: query_domain query_domain_domain_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_domain
    ADD CONSTRAINT query_domain_domain_id_fkey FOREIGN KEY (domain_id) REFERENCES ray.domain(id) ON DELETE CASCADE;


--
-- Name: query_domain query_domain_query_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_domain
    ADD CONSTRAINT query_domain_query_id_fkey FOREIGN KEY (query_id) REFERENCES ray.query(query_id) ON DELETE CASCADE;


--
-- Name: query_permission query_permission_permission_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_permission
    ADD CONSTRAINT query_permission_permission_id_fkey FOREIGN KEY (permission_id) REFERENCES ray.connection(connection_id) ON DELETE CASCADE;


--
-- Name: query_permission query_permission_query_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_permission
    ADD CONSTRAINT query_permission_query_id_fkey FOREIGN KEY (query_id) REFERENCES ray.query(query_id) ON DELETE CASCADE;


--
-- Name: query_permission query_permission_user_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_permission
    ADD CONSTRAINT query_permission_user_id_fkey FOREIGN KEY (user_id) REFERENCES ray."user"(id) ON DELETE CASCADE;


--
-- Name: query_run query_run_query_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.query_run
    ADD CONSTRAINT query_run_query_id_fkey FOREIGN KEY (query_id) REFERENCES ray.query(query_id) ON DELETE CASCADE;


--
-- Name: source_metadata source_metadata_connection_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.source_metadata
    ADD CONSTRAINT source_metadata_connection_id_fkey FOREIGN KEY (connection_id) REFERENCES ray.connection(connection_id) ON DELETE CASCADE;


--
-- Name: user_domain user_domain_domain_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.user_domain
    ADD CONSTRAINT user_domain_domain_id_fkey FOREIGN KEY (domain_id) REFERENCES ray.domain(id) ON DELETE CASCADE;


--
-- Name: user_domain user_domain_user_id_fkey; Type: FK CONSTRAINT; Schema: ray; Owner: gw-user
--

ALTER TABLE ONLY ray.user_domain
    ADD CONSTRAINT user_domain_user_id_fkey FOREIGN KEY (user_id) REFERENCES ray."user"(id) ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--

DROP TABLE IF EXISTS ray.migratehistory;

