#!/bin/bash

# Определение типа пакетного менеджера
detect_package_manager() {
    if command -v apt-get &> /dev/null; then
        echo "deb"
    elif command -v yum &> /dev/null || command -v dnf &> /dev/null; then
        echo "rpm"
    else
        echo "unknown"
    fi
}

# Функция для удаления Docker на Debian-based системах
remove_docker_deb() {
    echo "Обнаружена Debian-based система. Удаление Docker..."

    # Остановка и удаление Docker-контейнеров
    sudo docker-compose -f ./backend/docker-compose.yml down
    sudo docker-compose -f ./external_services/docker-compose.yml down



    # Удаление Docker-группы
    sudo delgroup docker

    # Удаление Docker-сервиса
    sudo systemctl stop docker
    sudo systemctl disable docker

    # Удаление Docker CE
    sudo apt-get purge -y docker.io docker-compose-v2

    echo "Docker успешно удален с Debian-based системы."
}

# Функция для удаления Docker на RPM-based системах
remove_docker_rpm() {
    echo "Обнаружена RPM-based система. Удаление Docker..."

    # Удаление Docker-группы
    # sudo delgroup docker

    # Удаление Docker-сервиса
    sudo systemctl stop docker
    sudo systemctl disable docker

    # Удаление Docker CE
    if command -v dnf &> /dev/null; then
        sudo dnf remove -y docker-ce docker-ce-cli docker-compose-switch
    elif command -v yum &> /dev/null; then
        sudo yum remove -y docker-ce docker-ce-cli docker-compose-switch
    fi

    echo "Docker успешно удален с RPM-based системы."
}

# Функция для удаления созданных директорий и файлов
remove_dir() {
    echo "Удаление созданных директорий и файлов..."

    # Удаление директории ray_project
    sudo rm -rf /opt/ray_project

    # Удаление файла authorized_keys
    # sudo rm -f ~/.ssh/authorized_keys

    echo "Директории и файлы успешно удалены."
}

# Функция для удаления Docker-контейнеров и образов
remove_docker_images() {
    echo "Остановка Docker-контейнеров..."

    sudo docker-compose -f ./backend/docker-compose.yml down
    sudo docker-compose -f ./external_services/docker-compose.yml down

    echo "Удаление Docker образов..."

    # Удаление всех Docker-контейнеров
    # sudo docker rm -f $(sudo docker ps -a -q)

    # Удаление всех Docker-образов
    sudo docker image prune -a -f

    echo "Docker образы успешно удалены."
}

# Основной код скрипта
package_manager=$(detect_package_manager)

case $package_manager in
    deb)
        # Удаление Docker образов
        remove_docker_images
        remove_docker_deb
        # Удаление созданных директорий и файлов
        remove_dir
        ;;
    rpm)
        remove_docker_images
        remove_docker_rpm
        # Удаление созданных директорий и файлов
        remove_dir
        ;;
    *)
        echo "Не удалось определить систему управления пакетами. Поддерживаются только Debian-based и RPM-based системы."
        exit 1
        ;;
esac

echo "Деинсталляция завершена."
echo "Для полного удаления рекомендуется перезагрузить компьютер"