#!/bin/bash

# Функция обновления файлов фронта
update_front() {
    sudo rm -rf /opt/ray_project/html/*
    sudo tar xvf ./dist.tar -C /opt/ray_project/html/

    # Замена IP-адреса в файлах
    sudo grep -rl "172.22.41.231" /opt/ray_project/html/ | sudo xargs sed -i "s/172.22.41.231/$internal_ips/g"

}
# Функция обновления фалов миграций
update_sql_mgr() {
    sudo cp ./sql_migrations /opt/ray_project/
}

# Функция для загрузки Docker образа из файла по маске
load_docker_image() {
    local image_mask=$1
    # Поиск файла, соответствующего маске
    local image_file=$(find . -name "$image_mask" -print -quit)

    if [[ -f $image_file ]]; then
        echo "Загрузка Docker образа из файла: $image_file"
        sg docker -c "docker load -i $image_file"
        if [[ $? -eq 0 ]]; then
            echo "Образ успешно загружен в Docker."
        else
            echo "Ошибка при загрузке образа."
            exit 1
        fi
    else
        echo "Файл образа, соответствующий маске $image_mask, не найден."
        exit 1
    fi
}

# Функция погдоготвки файла .env
prepare_env_file() {
    local env_file=".env"
    BACKEND_IMAGE_VER=$(sudo docker images --filter=reference='ray-gw' --format "{{.Tag}}")

    # Проверяем, существует ли переменная BACKEND_IMAGE_VER в файле .env
    if grep -q "^BACKEND_IMAGE_VER=" "$env_file"; then
        # Если строка существует, заменяем её значение на новое
        sed -i "s/^BACKEND_IMAGE_VER=.*/BACKEND_IMAGE_VER=${BACKEND_IMAGE_VER}/" "$env_file"
        echo "Значение BACKEND_IMAGE_VER обновлено в файле $env_file."
    else
        # Если строка отсутствует, добавляем её в конец файла
        echo "BACKEND_IMAGE_VER=${BACKEND_IMAGE_VER}" | tee -a "$env_file"
        echo "Строка BACKEND_IMAGE_VER добавлена в файл $env_file."
    fi

    sed -i "s|^RAY_SSH_MASTER_HOST=.*|RAY_SSH_MASTER_HOST=developer@${internal_ips}|" "$env_file"
    sed -i "s|^VITE_APP_API_HOST=.*|VITE_APP_API_HOST=http://${internal_ips}:8082|" "$env_file"
    cp .env ./external_services/
    cp .env ./backend/
}

# Функция обновления контейнеров ray-gw
update_docker_images() {
    sg docker -c "docker compose -f ./backend/docker-compose.yml up -d"
    
}

# Обновление файлов статики для frontend
update_front

# Обновление фалов в папке с миграциями
update_sql_mgr

# Копирование обновленного DAG
sudo cp external_services/trino.py /opt/ray_project/airflow-volume/dags/

# Загрузка обновленного образа ray_gw
load_docker_image "ray-gw.tar.gz"

# Подготовка файла .env
prepare_env_file

# Обновление контейнеров Луча
update_docker_images